import Plugin from 'src/plugin-system/plugin.class'
import HttpClient from 'src/service/http-client.service';

export default class ServicePointLocator extends Plugin {
    static options = {
        locatorComponentJsUrl: 'https://static.dhlparcel.nl/components/servicepoint-locator-component@latest/servicepoint-locator-component.js',
        locatorComponentCssUrl: 'https://static.dhlparcel.nl/fonts/Delivery.css',
        selectClosestTries: 0,
    }

    init()
    {
        // initalize the HttpClient
        this._client = new HttpClient()

        // Initiate ServicePoint locator
        const servicePointLocator = this
        this.loadCss(this.options.locatorComponentCssUrl)
        this.loadScript(this.options.locatorComponentJsUrl, function () {
            servicePointLocator.initServicePointlocator()
        })

    }

    selectServicePoint(selectedServicePoint)
    {
        if (typeof selectedServicePoint !== 'object') {
            return
        }

        document.getElementById('dhlparcel_shipping_servicepoint_id').value = selectedServicePoint.id
        document.getElementById('dhlparcel-shipping-servicepoint-address').innerHTML =
            '<p><i>' + selectedServicePoint.name + '</i><br />' +
            selectedServicePoint.address.street + ' ' + selectedServicePoint.address.number + '<br />' +
            selectedServicePoint.address.zipCode + ' ' + selectedServicePoint.address.city +
            '</p>'

        // Close modal
        document.querySelector('#dhlparcelShippingChangeServicePoint .close').click()
    }

    initServicePointlocator()
    {
        var configElement = document.getElementById('dhl-servicepoint-locator-component')
        var limit = configElement.dataset.limit
        var apiKey = configElement.dataset.mapsKey
        var countryId = configElement.dataset.countryId
        var postcode = configElement.dataset.postcode

        var options = {
            limit: limit,
            country: countryId,
            query: postcode,
            googleMapsApiKey: apiKey,
            header: true,
            resizable: true,
            onSelect: this.selectServicePoint,
        }

        // Use the generated function provided by the component to load the ServicePoints
        var locator = new dhl.servicepoint.Locator(document.getElementById("dhl-servicepoint-locator-component"), options);
        this.selectClosestServicePoint(postcode, countryId)
    }

    selectClosestServicePoint(postalCode, countryId)
    {
        // Skip this step when there is no data available
        if (!postalCode || !countryId){
            return
        }

        // Get and select closest servicepoint
        const servicePointLocator = this
        this._client.get('https://api-gw.dhlparcel.nl/parcel-shop-locations/' + countryId + '?limit=1&postalCode=' + postalCode + '&serviceType=parcel-last-mile', (rawResponse) => {
            const response = JSON.parse(rawResponse)

            if (typeof response[0] === 'object') {
                servicePointLocator.selectServicePoint(response[0])
            }
        }, 'application/json')
    }

    loadScript(url, callback)
    {
        var script = document.createElement('script')
        script.type = 'text/javascript'
        script.src = url

        // Then bind the event to the callback function.
        // There are several events for cross browser compatibility.
        script.onreadystatechange = callback
        script.onload = callback

        document.head.appendChild(script)
    }

    loadCss(url)
    {
        var css = document.createElement('link')
        css.rel  = 'stylesheet'
        css.href = url

        document.head.appendChild(css)
    }
}
