<?php declare(strict_types=1);

namespace DHLParcel\Shipping\Service;

use Shopware\Core\System\SystemConfig\SystemConfigService;

class ConfigService
{
    const CONFIG_DOMAIN = 'DHLParcelShipping';
    const CONFIG_KEY_STATUS = 'status';
    const CONFIG_KEY_WEBHOOKURL = 'webhookurl';
    const CONFIG_KEY_EVENT_TRIGGER = 'eventTrigger';
    const CONFIG_KEY_SERVICEPOINT_ENABLED = 'servicepointEnabled';
    const CONFIG_KEY_GOOGLEMAPS_API_KEY = 'googleMapsApiKey';
    const CONFIG_KEY_SERVICEPOINT_SHIPPING_METHOD = 'servicepointShippingMethod';

    /**
     * @var SystemConfigService
     */
    protected $systemConfigService;

    /**
     * @param SystemConfigService $systemConfigService
     */
    public function __construct(SystemConfigService $systemConfigService)
    {
        $this->systemConfigService = $systemConfigService;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return boolval($this->getConfig(self::CONFIG_KEY_STATUS));
    }

    /**
     * @return string
     */
    public function getWebhookUrl(): string
    {
        return strval($this->getConfig(self::CONFIG_KEY_WEBHOOKURL));
    }

    /**
     * @return string
     */
    public function getGoogleMapsApiKey(): string
    {
        return strval($this->getConfig(self::CONFIG_KEY_GOOGLEMAPS_API_KEY));
    }

    /**
     * @return string
     */
    public function getServicePointShippingMethod(): string
    {
        return strval($this->getConfig(self::CONFIG_KEY_SERVICEPOINT_SHIPPING_METHOD));
    }

    /**
     * @return bool
     */
    public function isSevicepointEnabled(): bool
    {
        return boolval($this->getConfig(self::CONFIG_KEY_SERVICEPOINT_ENABLED));
    }

    /**
     * @param string $eventName
     *
     * @return bool
     */
    public function isConfiguredForEvent(string $eventName): bool
    {
        $configuredEvent = $this->getConfig(self::CONFIG_KEY_EVENT_TRIGGER);

        return ($configuredEvent ?: 'Shopware\Core\Checkout\Cart\Event\CheckoutOrderPlacedEvent') === $eventName;
    }

    /**
     * @param string $key
     *
     * @return mixed|string
     */
    protected function getConfig(string $key)
    {
        $configs = $this->systemConfigService->all();

        return $configs[self::CONFIG_DOMAIN]['config'][$key] ?? '';
    }
}
