<?php declare(strict_types = 1);

namespace DHLParcel\Shipping\Service;

use Shopware\Core\Checkout\Cart\Cart;
use Shopware\Core\Checkout\Cart\Delivery\Struct\Delivery;
use Shopware\Core\Checkout\Shipping\ShippingMethodEntity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;
use Shopware\Core\System\SalesChannel\Context\SalesChannelContextFactory;

class ServicePointService
{
    const CUSTOM_FIELD_SERVICEPOINT_ID = 'dhlparcel_shipping_servicepoint_id';
    /**
     * @var ConfigService
     */
    protected $configService;

    /**
     * WebhookService constructor.
     * @param ConfigService $configService
     */
    public function __construct(
        ConfigService $configService
    ) {
        $this->configService = $configService;
    }

    /**
     * @param $cart
     * @return bool
     */
    public function isServicePointByCart(Cart $cart) : bool
    {
        // Shipping Method
        $deliveries = $cart->getDeliveries()->getElements();
        $delivery = array_shift($deliveries);
        if (!$delivery instanceof Delivery) {
            return false;
        }

        /**
         * @var $shippingMethod ShippingMethodEntity
         */
        $shippingMethod = $delivery->getShippingMethod();

        return ($shippingMethod->getId() === $this->configService->getServicePointShippingMethod());
    }
}
