<?php declare(strict_types=1);

namespace DHLParcel\Shipping\Subscriber;

use DHLParcel\Shipping\Service\ConfigService;
use DHLParcel\Shipping\Service\ServicePointService;
use Shopware\Storefront\Page\Checkout\Confirm\CheckoutConfirmPageLoadedEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Contracts\EventDispatcher\Event;

class CheckoutSubscriber implements EventSubscriberInterface
{
    /**
     * @var ConfigService
     */
    protected $configService;

    /**
     * @var ServicePointService
     */
    protected $servicePointService;

    /**
     * CheckoutSubscriber constructor.
     * @param ConfigService $configService
     * @param ServicePointService $servicePointService
     */
    public function __construct(
        ConfigService $configService,
        ServicePointService $servicePointService
    ) {
        $this->configService = $configService;
        $this->servicePointService = $servicePointService;
    }

    /**
     * @return array
     */
    public static function getSubscribedEvents(): array
    {
        return [
            CheckoutConfirmPageLoadedEvent::class => 'checkoutConfirmPageLoadedEvent'
        ];
    }

    /**
     * @param Event $event
     */
    public function checkoutConfirmPageLoadedEvent(Event $event): void
    {
        /**
         * @var $page \Shopware\Storefront\Page\Checkout\Confirm\CheckoutConfirmPage
         */
        $page = $event->getPage();
        $cart = $page->getCart();

        if (!$this->configService->isEnabled()
            || !$this->configService->isSevicepointEnabled()
            || !$this->configService->getGoogleMapsApiKey()
            || !$this->servicePointService->isServicePointByCart($cart)
        ) {
            return;
        }

        // Assign variables
        $servicepoint = new \stdClass();
        $servicepoint->apiKey = $this->configService->getGoogleMapsApiKey() ?? '';
        // @todo make this dynamic, but I can't retreive the current locale
        $servicepoint->locale = 'nl-NL';

        $page->dhlparcelShippingServicePoint = $servicepoint;
    }
}
